/* mr_conf.h
 *
 * $Id$
 *
 * based on parse_conf.h (c)2002-2004 Anton Kulchitsky  mailto:anton@kulchitsky.org
 * Reviewed for mondorescue (c) 2006-2007 Bruno Cornec <bruno@mondorescue.org>
 *   
 *     Header file of mr_conf: a very small and simple
 *     library for mondorescue configuration file reading
 *
 * Provided under the GPLv2
 */

#ifndef MR_CONF_H
#define MR_CONF_H

#include "mr_types.h"

/* mondoarchive structure storing conf info 
 * each field of the configuration file should have an entry here
 */
struct mr_ar_conf {
	/* MINDI: ISO image CLI command to use */
	char *iso_creation_cmd;
	/* MINDI: ISO image common creation options */
	char *iso_creation_opt;
	/* ISO Burning CLI command to use */
	char *iso_burning_cmd;
	/* ISO Burning device to use (optional) */
	char *iso_burning_dev;
	/* ISO Burning CLI command options */
	char *iso_burning_opt;
	/* ISO Burning Speed */
	int iso_burning_speed;
	/* Default size of media */
	int media_size;
	/* Default device of media */
	char *media_device;
	/* Is the CD tray manual ? */
	bool manual_tray;
	/* Default log level */
	int log_level;
	/* default prefix for ISO names */
	char *prefix;
	/* External tape blocksize */
	int external_tape_blocksize;
	/* Internal tape blocksize */
	int internal_tape_blocksize;
	/* Kernel to use */
	char *kernel;
	/* Additional modules to support */
	char *additional_modules;
	/* Boot loader to use */
	char *boot_loader;
	/* Differential backup ? */
	bool differential;
	/* Default compression tool */
	char *compression_tool;
	/* Default compression level */
	int compression_level;
	/* Subdir for ISO images on HDD */
	char *subdir;
	/* Paths to exclude from backup */
	char *exclude_paths;
	/* Paths to include onto the backup */
	char *include_paths;
	/* Which mode should be activated by default*/
	char *ui_mode;
	/* Activate automatic restore ? */
	bool automatic_restore;
	/* Scratch directory */
	char *scratch_dir;
	/* Temporary directory main path */
	char *tmp_dir;
	/* Images creation dir */
	char *images_dir;
};

/* mondorestore structure storing conf info 
 * each field of the configuration file should have an entry here
 */
struct mr_rs_conf {
	/* Default media size */
	int media_size;
	/* Default device of media */
	char *media_device;
	/* Is the CD tray manual ? */
	bool manual_tray;
	/* Default log level */
	int log_level;
	/* default prefix for ISO names */
	char *prefix;
	/* External tape blocksize */
	int external_tape_blocksize;
	/* Internal tape blocksize */
	int internal_tape_blocksize;
	/* Boot loader to use */
	char *boot_loader;
	/* Differential backup ? */
	bool differential;
	/* Default compression tool */
	char *compression_tool;
	/* Which mode should be activated by default*/
	char *ui_mode;
	/* Activate automatic restore ? */
	bool automatic_restore;
	/* Images creation dir */
	char *images_dir;
};

/* functions (public methods) */

/*initialization and closing*/
extern int mr_conf_open(const char *filename);
extern void mr_conf_close(void);

/*read integer number (under a string format to be freed later on) after string str in the current file*/
/* use atoi after */
extern char *mr_conf_iread(const char *field_name);

/*read double/float number (under a string format to be freed later on) after string str in the current file*/
/* use atof after */
extern char *mr_conf_fread(const char *field_name);

/*read boolean (under a string format to be freed later on) after string str in the current file*/
/* use mr_atob after */
extern char *mr_conf_bread(const char *field_name);

/*
 * read string after string str in the current file.
 * This function allocates the string which has to be freed later on 
*/
extern char *mr_conf_sread(const char *field_name);

#endif							/* MR_CONF_H */
