/* mr_file.h
 *
 * $Id$
 *
 * (c) 2006 Bruno Cornec <bruno@mondorescue.org>
 *   
 * Header file of mr_file
 *
 * Provided under the GPLv2
 */

#ifndef MR_FILE_H
#define MR_FILE_H

#include <stdio.h>

/* functions (public methods) */

#define mr_fopen(x,y)			mr_fopen_int((const char *)x, (const char *)y,__LINE__,__FILE__)
#define mr_fprintf(x,y,args...)	mr_fprintf_int(x,__LINE__,__FILE__,y,## args)
#define mr_fclose(x)			mr_fclose_int((FILE **)&x, __LINE__,__FILE__)
#define mr_mkdir(x,y)			mr_mkdir_int((const char *)x,(mode_t)y,__LINE__,__FILE__)

extern FILE *mr_fopen_int(const char *path, const char *mode,int line, char *file);
extern FILE *mr_fprintf_int(FILE *stream,int line, char *file, const char *fmt, ...);
extern void mr_fclose_int(FILE **fd, int line, char *file);
extern void mr_mkdir_int(const char *pathname, mode_t mode, int line, char *file);

#endif							/* MR_FILE_H */
