#
# $Id$
#
%define perlvendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)
%define srcname project-builder-server

Summary:	Perl server providing a REST API for Project-Builder.org Continuous Packaging

Name:		project-builder-server
Version:	0.16.1
Release:	1.opensuse10.2
License:	GPLv2
Group:		System/Configuration/Packaging
Url:		http://trac.project-builder.org
Source:		ftp://ftp.project-builder.org//src/%{srcname}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{srcname}-%{version}-%{release}-root-%(id -u -n)
BuildArch:	noarch
Requires:	perl >= 5.6.2,perl-YAML,perl-Mojolicious,perl-Mojolicious-Plugin-OpenAPI,perl-YAML-LibYAML


%description
project-builder-server is a perl module providing a REST API
to help using project-builder in a client server mode.

%prep
%setup -q -n %{srcname}-%{version}

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor destdir=${RPM_BUILD_ROOT}/ SYSCONFDIR=%{_sysconfdir}/pb CONFDIR=%{_datadir}/pb MANDIR=%{_mandir}
make %{?_smp_mflags}

%install
%{__rm} -rf $RPM_BUILD_ROOT
make DESTDIR=${RPM_BUILD_ROOT} install
find ${RPM_BUILD_ROOT} -type f -name perllocal.pod -o -name .packlist -o -name '*.bs' -a -size 0 | xargs rm -f
find ${RPM_BUILD_ROOT} -type d -depth | xargs rmdir --ignore-fail-on-non-empty

%check
make test

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc NEWS AUTHORS
%doc COPYING README

%{perlvendorlib}/*
%{_bindir}/*
%{_mandir}/man1/*
#%{_mandir}/man3/*
#%{_mandir}/man5/*

%changelog
* Wed Aug 19 2020 Bruno Cornec <bruno@project-builder.org> 0.16.1-1
- Updated to 0.16.1
- More tests around bootstrap, nodejs to evalutae techno (Bruno Cornec)
- Still not ready yet

* Thu Apr 02 2020 Bruno Cornec <bruno@project-builder.org> 0.15.3-1
- Updated to 0.15.3
- Remove swagger2 module dep as not maintained anymore (Bruno Cornec)

* Sat Sep 07 2019 Bruno Cornec <bruno@project-builder.org> 0.15.2-1
- Updated to 0.15.2
- No change

* Mon Mar 18 2019 Bruno Cornec <bruno@project-builder.org> 0.15.1-1
- Updated to 0.15.1
- Not ready yet


